<?php
  /**
   * Download
   *
   * @package Digital Downloads Pro
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: download.php, v2.00 2011-04-20 10:12:05 gewa Exp $
   */
  define("_VALID_PHP", true);
  
  require_once("init.php");
  define('BASE_DIR', $core->file_dir);
  
  $allowed_ext = array(
		'zip' => 'application/zip', 
		'pdf' => 'application/pdf', 
		'doc' => 'application/msword', 
		'xls' => 'application/vnd.ms-excel', 
		'ppt' => 'application/vnd.ms-powerpoint', 
		'exe' => 'application/octet-stream', 
		'gif' => 'image/gif', 
		'png' => 'image/png', 
		'jpg' => 'image/jpeg', 
		'jpeg' => 'image/jpeg', 
		'mp3' => 'audio/mpeg', 
		'wav' => 'audio/x-wav', 
		'mpeg' => 'video/mpeg', 
		'mpg' => 'video/mpeg', 
		'mpe' => 'video/mpeg', 
		'mov' => 'video/quicktime', 
		'avi' => 'video/x-msvideo'
  );
  
  set_time_limit(0);
  
  if (ini_get('zlib.output_compression')) {
      ini_set('zlib.output_compression', 'Off');
  }
?>
<?php
  if (isset($_GET['fid'])) {
      $fid = intval($_GET['fid']);
      
      $row = $db->first("SELECT f.alias, f.name, p.id as pid, p.file_id, p.price, p.active" 
	  . " \n FROM products as p" 
	  . " \n LEFT JOIN files as f ON f.id = p.file_id " 
	  . " \n WHERE p.id = '" . $db->escape($fid) . "'" 
	  . " \n AND p.price = '0'" 
	  . " \n AND p.active = '1'");
      
      if ($row) {
          $fname = basename($row['name']);
		  $file_path = '';
          $core->fetchFile(BASE_DIR, $fname, $file_path);
		  
          $fsize = filesize($file_path);
          $fext = strtolower(substr(strrchr($fname, "."), 1));
          
          if (!file_exists($file_path) || !is_file($file_path)) {
              redirect_to(SITEURL . "/index.php?msg=1");
              die();
          }
          
          if (!array_key_exists($fext, $allowed_ext)) {
              redirect_to(SITEURL . "/index.php?msg=2");
              die();
          }
          
          if ($core->free_allowed == 0 && !$user->logged_in) {
              redirect_to(SITEURL . "/index.php?msg=3");
              die();
          }
          
          if ($allowed_ext[$fext] == '') {
              $mtype = '';
              if (function_exists('mime_content_type')) {
                  $mtype = mime_content_type($file_path);
              } elseif (function_exists('finfo_file')) {
                  $finfo = finfo_open(FILEINFO_MIME);
                  $mtype = finfo_file($finfo, $file_path);
                  finfo_close($finfo);
              }
              if ($mtype == '') {
                  $mtype = "application/force-download";
              }
          } else {
              $mtype = $allowed_ext[$fext];
          }
          
          // set headers
          header("Pragma: public");
          header("Expires: 0");
          header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
          header("Cache-Control: public");
          header("Content-Description: File Transfer");
          header("Content-Type: $mtype");
          header("Content-Disposition: attachment; filename=\"$fname\"");
          header("Content-Transfer-Encoding: binary");
          header("Content-Length: " . $fsize);
          
          print $core->readFile($file_path, true);
      } else {
          redirect_to(SITEURL . "/index.php");
      }
  } elseif (isset($_GET['pid']) && $user->logged_in) {
      $pid = intval($_GET['pid']);
      
      $row = $db->first("SELECT t.*, t.id as tid, COUNT(t.item_qty) as count, t.active as tactive, t.status as tstatus," 
	  . " \n p.id as pid, p.expiry, p.file_id as fid, p.price as prodprice," 
	  . " \n u.id as uid" 
	  . " \n FROM transactions as t" 
	  . " \n LEFT JOIN products as p ON t.pid = p.id" 
	  . " \n LEFT JOIN users as u ON t.uid = u.id" 
	  . " \n WHERE t.pid = '" . $db->escape($pid) . "'" 
	  . " \n AND t.status = '1' AND t.active = '1'" 
	  . " \n AND p.active = '1' AND t.uid = '" . $user->uid . "'"
	  . " \n GROUP BY p.id");
      
      if ($row) {
          if ($row['expiry'] != 0 && $row['tactive'] == 1) {
              if (substr_count($row['expiry'], 'D') != 0) {
                  $expiry = substr($row['expiry'], 1) * $row['count'];
                  
                  $current_time = time();
                  $expiry_time = $row['count'] + ($expiry * 24 * 60 * 60);
                  if ($current_time > $expiry_time) {
                      $expired = true;
                  }
              } else {
                  if ($row['downloads'] >= ($row['expiry'] * $row['count'])) {
                      $expired = true;
                  }
              }
          }
          
          if (isset($expired)) {
              redirect_to(SITEURL . "/view.php?msg=4");
              die();
          }
          
          $frow = $db->first("SELECT alias, name FROM files WHERE id = '" . (int)$row['fid'] . "'");
          
		  $fname = basename($frow['name']);
          $file_path = '';
		  
		  $core->fetchFile(BASE_DIR, $fname, $file_path);
          $fsize = filesize($file_path);
          $fext = strtolower(substr(strrchr($fname, "."), 1));
          
          if (!file_exists($file_path) || !is_file($file_path)) {
              redirect_to(SITEURL . "/index.php?msg=1");
              die();
          }
          
          if (!array_key_exists($fext, $allowed_ext)) {
              redirect_to(SITEURL . "/index.php?msg=2");
              die();
          }
		  
          $data['downloads'] = "INC(1)";
          $db->update("transactions", $data, "id='" . $row['tid'] . "'");
		  
          if ($allowed_ext[$fext] == '') {
              $mtype = '';
              if (function_exists('mime_content_type')) {
                  $mtype = mime_content_type($file_path);
              } elseif (function_exists('finfo_file')) {
                  $finfo = finfo_open(FILEINFO_MIME);
                  $mtype = finfo_file($finfo, $file_path);
                  finfo_close($finfo);
              }
              if ($mtype == '') {
                  $mtype = "application/force-download";
              }
          } else {
              $mtype = $allowed_ext[$fext];
          }
          
          // set headers
          header("Pragma: public");
          header("Expires: 0");
          header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
          header("Cache-Control: public");
          header("Content-Description: File Transfer");
          header("Content-Type: $mtype");
          header("Content-Disposition: attachment; filename=\"$fname\"");
          header("Content-Transfer-Encoding: binary");
          header("Content-Length: " . $fsize);
          
          print $core->readFile($file_path, true);
      } else {
          redirect_to(SITEURL . "/index.php");
      }
  } else {
	   redirect_to(SITEURL . "/index.php?msg=5");
	   die();
  }
?>